/*
 * QrfeRfePurHidKeyboardReader.h
 *
 *  Created on: 11.12.2013
 *      Author: stefan.detter
 */

#ifndef QRFERFEPURHIDKEYBOARDREADER_H_
#define QRFERFEPURHIDKEYBOARDREADER_H_

#include "../QrfeRfePurReader.h"

#include <QrfeTraceModule>

class QrfeRfePurHidKeyboardReader : public QrfeRfePurReader
{
	Q_OBJECT

	typedef enum {
		GET_SETTINGS 			= 0x00,
		SET_SETTINGS			= 0x01,
		START_AUTOMATIC_SEARCH 	= 0x02,
		STOP_AUTOMATIC_SEARCH 	= 0x03,
		GET_SEARCH_RESULTS		= 0x04,
		BLOCK_WRITE 			= 0x10,
		BLOCK_READ	 			= 0x11,
	} COMMANDS;

public:
	typedef struct {
		ushort attenuation;
		ushort powerSafeTime;
		bool prependEnter;
		bool appendEnter;
		ulong deleteTime;
	} SETTINGS;

	QrfeRfePurHidKeyboardReader(QrfeProtocolHandlerRFE* ph, QObject* parent = 0);
	virtual ~QrfeRfePurHidKeyboardReader();

	QrfeGlobal::Result getSettings ( QrfeRfePurHidKeyboardReader::SETTINGS& settings );
	QrfeGlobal::Result setSettings ( const QrfeRfePurHidKeyboardReader::SETTINGS& settings );

};

#endif /* QRFERFEPURHIDKEYBOARDREADER_H_ */
